<?php

declare(strict_types=1);

class MageQL_Sales_Model_Test_Observer extends Mage_Core_Model_Abstract {
    public function quoteSubmitAllAddErrors(Varien_Event_Observer $event): void {
        $errors = $event->getErrors();

        $errors->setData("errorTheTestApiExceptionHappened", [
            "apiErrorCode" => 23,
            "description" => "Error for test of api exception",
        ]);
    }

    public function quoteSubmitAllBeforeException(): void {
        throw Crossroads_API_ResponseException::create(403, "Not permitted", null, 23);
    }

    public function quoteSubmitAllBeforeUnknownException(): void {
        // Unknown error code
        throw Crossroads_API_ResponseException::create(403, "The unknown exception", null, 123);
    }
}
