<?php

declare(strict_types=1);

class MageQL_Sales_Model_BuyRequest_Product_Configurable extends MageQL_Sales_Model_BuyRequest_Product {
    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $parent;

    /**
     * @var Mage_Catalog_Model_Resource_Product_Type_Configurable_Attribute_Collection
     */
    protected $attributes;

    public function __construct(
        Mage_Catalog_Model_Product $parent,
        Mage_Catalog_Model_Product $child,
        Mage_Catalog_Model_Resource_Product_Type_Configurable_Attribute_Collection $attributes
    ) {
        $this->parent = $parent;
        $this->product = $child;
        $this->attributes = $attributes;
    }

    public function getAttributeMap(): array {
        $requestAttrs = [];

        foreach($this->attributes as $attr) {
            $prodAttr = $attr->getProductAttribute();

            $requestAttrs[$prodAttr->getAttributeId()] = (int)$this->product->getData($prodAttr->getAttributeCode());
        }

        return $requestAttrs;
    }

    public function getBuyRequest(): array {
        return [
            "super_attribute" => $this->getAttributeMap(),
        ];
    }

    public function getPayload(): array {
        return [
            "p" => (int)$this->parent->getId(),
            "a" => $this->getAttributeMap(),
        ];
    }
}
