<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

/**
 * @psalm-type ConfigurationOptionItem array{0:Mage_Catalog_Model_Product, 1:Array<Mage_Catalog_Model_Product_Type_Configurable_Attribute>}
 */
class MageQL_Sales_Model_Product extends Mage_Core_Model_Abstract {
    /**
     * Generates a buy request for a simple/virtual product.
     */
    public static function resolveBuyRequestSimple(
        Mage_Catalog_Model_Product $src,
        array $unusedArgs,
        MageQL_Core_Model_Context $ctx
    ): ?string {
        $req = MageQL_Sales_Model_Product_Buyrequest::fromProduct($src, $ctx->getStore());

        return $req ? (string)$req : null;
    }

    /**
     * Generates a buy-request string for a configurable item which can be used
     * to add a product to a quote.
     *
     * @param ConfigurationOptionItem $src
     */
    public static function resolveBuyRequestConfigItem($src): ?string {
        $req = MageQL_Sales_Model_Product_Buyrequest_Configurable::fromChildProduct($src[0], $src[1]);

        return $req ? (string)$req : null;
    }

    /**
     * Generates the basic buyRuquest for a bundle product to be completed with
     * options.
     */
    public static function resolveBuyRequestBaseBundle(
        Mage_Catalog_Model_Product $src
    ): string {
        if($src->getTypeId() !== "bundle") {
            throw new Exception(sprintf(
                "%s: Requires bundle produc type, got '%s'.",
                __METHOD__,
                $src->getTypeId()
            ));
        }

        return json_encode([
            "p" => (int)$src->getId(),
        ]);
    }
}
