<?php

declare(strict_types=1);

/**
 * @psalm-type Result self::SUCCESS|self::NOT_MODIFIED|self::ERROR_NOT_LOGGED_IN
 */
class MageQL_Sales_Model_Quote_Address_Result {
    const SUCCESS = "success";
    const NOT_MODIFIED = "notModified";
    const ERROR_NOT_LOGGED_IN = "errorNotLoggedIn";

    /**
     * @var Result
     */
    protected $result;

    /**
     * @var ?Mage_Customer_Model_Address_Abstract
     */
    protected $address;

    /**
     * @param Result $result
     */
    public function __construct(
        $result,
        Mage_Customer_Model_Address_Abstract $address = null
    ) {
        $this->result = $result;
        $this->address = $address;
    }

    /**
     * @return Result
     */
    public function getResult(): string {
        return $this->result;
    }

    public function getAddress(): ?Mage_Customer_Model_Address_Abstract {
        return $this->address;
    }

    public function getValidationErrors(): ?array {
        if($this->address) {
            return MageQL_Core_Model_Address::resolveValidationErrors($this->address);
        }

        return [];
    }
}
