<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Sales_Model_Product_Buyrequest extends Mage_Core_Model_Abstract {
    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    protected function __construct(Mage_Catalog_Model_Product $product) {
        $this->product = $product;
    }

    /**
     * Creates a buy request from a single product, will return null if it is
     * not possible to create a request for the specific product (either not
     * saleable or requires additional options).
     */
    public static function fromProduct(
        Mage_Catalog_Model_Product $product,
        Mage_Core_Model_Store $store
    ): ?self {
        switch($product->getTypeId()) {
        case "bundle":
            if( ! $product->isSalable()) {
                return null;
            }

            return MageQL_Sales_Model_Product_Buyrequest_Bundle::fromProduct($product, $store);

        case "configurable":
            // Configs require a buyRequest from a variant
            return null;

        case "simple":
        case "virtual":
            if( ! $product->isSalable()) {
                return null;
            }

            if($product->getParentId()) {
                return null;
            }

            return new self($product);

        default:
            throw new Exception(sprintf("%s: Unknown product type %s", __METHOD__, $product->getTypeId()));
        }
    }

    public function toRequest(): array {
        return [
            "p" => (int)$this->product->getId(),
        ];
    }

    public function __toString() {
        return (string)json_encode($this->toRequest());
    }
}
