<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

/**
 * @psalm-type ConfigurableAttributes Array<int, int>
 */
class MageQL_Sales_Model_Product_Buyrequest_Configurable extends MageQL_Sales_Model_Product_Buyrequest {
    /**
     * @var ConfigurableAttributes
     */
    protected $attributes;

    /**
     * @param ConfigurableAttributes $attributes
     */
    protected function __construct(Mage_Catalog_Model_Product $product, array $attributes) {
        $this->product = $product;
        $this->attributes = $attributes;
    }

    /**
     * Creates a buy request from a child-product and configuration attributes.
     * @param Array<Mage_Catalog_Model_Product_Type_Configurable_Attribute> $configAttrs
     */
    public static function fromChildProduct(
        Mage_Catalog_Model_Product $child,
        $configAttrs
    ): ?self {
        $requestAttrs = [];

        if( ! in_array($child->getTypeId(), ["simple", "virtual"])) {
            throw new Exception(sprintf("%s: Invalid product type %s for config child", __METHOD__, $child->getTypeId()));
        }

        if( ! $child->getParentId()) {
            throw new Exception(sprintf("%s: Invalid parent product id on %s (%d) for config child", __METHOD__, $child->getSku(), $child->getId()));
        }

        if( ! $child->isSalable()) {
            return null;
        }

        foreach($configAttrs as $attr) {
            $prodAttr = $attr->getProductAttribute();

            $requestAttrs[$prodAttr->getAttributeId()] = (int)$child->getData($prodAttr->getAttributeCode());
        }

        return new self($child, $requestAttrs);
    }

    public function toRequest(): array {
        return [
            "p" => (int)$this->product->getParentId(),
            "a" => $this->attributes,
        ];
    }
}
