# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [2.2.0] - 2020-03-02
### Added
- `Order`.`grandTotal` `Price`.
- `Order`.`subTotal` `Price`.
- `Order`.`virtual` boolean.
- `Order`.`shipping` containing shipping information.
- `Order`.`currencyCode` containing currency used to place the order.

## [2.1.0] - 2020-02-11
### Added
- `orderById` query to show a specific order
- `createdAt` field on `Order`.
- `orders` field on `Customer` with paginated orders.

## [2.0.0] - 2020-02-10
### Added
- Mutation to set quote addresses to customer defaults.
### Changed
- Updated for Core version 2 release.
- Updated for Catalog version 3 release.
## Changed
- LATE NOTE: `SetQuoteBillingAddressInput` and `SetQuoteShippingAddress` are
  replaced by `AddressInput` in `setQuoteBillingAddress` and `setQuoteShippingAddress`.

## [1.3.0] - 2019-12-18
### Added
- `QuoteItem`.`canOrder` boolean which will be true if the item can be ordered
  (ie. in stock in sufficient amount).
- `removeUnorderableQuoteItems` mutation which removes any order items which
  can not be ordered, this mutation will also list any removed items.

## [1.2.0] - 2019-12-13
### Added
- Added defaults to addresses when the user is logged in based on the customer
  acount default addresses, it will replace any empty addresses when saving
  the quote.
- Quote addresses will default to the customer default addresses on login if
  not already populated.
- Added error `errorProductsNotAvailable` to type `PlaceOrderResultType` for
  `placeOrder` mutation result.
### Fixed
- Fixed crash when products in quote are not available for sale when attempting
  to place an order.

## [1.1.0] - 2019-11-22
### Added
- Support for bundles.
### Fixed
- Qty updates now modify the existing item instead of replacing it with a new.

## [1.0.7] - 2019-11-01
### Fixed
- Products which are invisible or not assigned can no longer be added to cart.
- Improved internal types.

## [1.0.6] - 2019-08-28
### Changed
- Updated to handle MageQL Core v1.0.6.

## [1.0.5] - 2019-08-23
### Changed
- `setQuoteEmail` is now no longer usable when a customer is logged in, use
  `updateCustomerEmail` instead.

## [1.0.4] - 2019-08-23
### Fixed
- Bugfix for `MageQL_Sales_ErrorInterface`.

## [1.0.3] - 2019-08-23
### Fixed
- Bugfix for `MageQL_Sales_ErrorInterface` and the event
  `mageql_sales_place_order_result_type`.

## [1.0.2] - 2019-08-22
### Added
- Added possibility to register custom result values for `placeOrder` and also
  map `Crossroads_API_ResponseException` to these.

## [1.0.1] - 2019-08-16
### Changed
- Updated package dependencies to reference actual versions.

## [1.0.0] - 2019-08-16
### Added
- Initial release.