<?php

declare(strict_types=1);

namespace Fixtures;

use Mage;
use Mage_Core_Model_Resource_Setup;
use Crossroads\Magento\Test\Integration\MagentoManager;

class Order {
    public function load(): void {
        MagentoManager::initAdmin();

        $store = Mage::app()->getStore(MagentoManager::TESTING_STORE);
        $order = Mage::getModel("sales/order");
        $simple = Mage::getModel("catalog/product")->load(Mage::getModel("catalog/product")->getIdBySku("test-simple"));
        $config = Mage::getModel("catalog/product")->load(Mage::getModel("catalog/product")->getIdBySku("test-config"));
        $configChild1 = Mage::getModel("catalog/product")->load(Mage::getModel("catalog/product")->getIdBySku("test-config-child-1"));
        $bundle = Mage::getModel("catalog/product")->load(Mage::getModel("catalog/product")->getIdBySku("test-bundle-select"));
        $bundleSelect2 = Mage::getModel("catalog/product")->load(Mage::getModel("catalog/product")->getIdBySku("test-bundle-select-2"));
        $customer = Mage::getModel("customer/customer")
            ->setWebsiteId($store->getWebsiteId())
            ->loadByEmail("test-customer@example.com");

        $order->loadByIncrementId("TEST-1");

        $order->addData([
            "increment_id" => "TEST-1",
            "state" => "processing",
            "status" => "processing",
            "protect_code" => "12345",
            "shipping_description" => "The shipping description",
            "is_virtual" => 0,
            "store_id" => $store->getId(),
            "base_discount_amount" => 0,
            "base_shipping_amount" => 12,
            "base_shipping_tax_amount" => 12 * 0.25,
            "base_shipping_incl_tax" => 12 * 1.25,
            "base_subtotal" => 1337,
            "base_subtotal_inc_tax" => 1337 * 1.25,
            "base_tax_amount" => 1337 * 0.25,
            "base_to_global_rate" => 1,
            "base_to_order_rate" => 1,
            "base_grand_total" => (1337 + 12) * 1.25,

            "created_at" => "2020-01-02 13:37",

            "discount_amount" => 0,
            "shipping_amount" => 12,
            "shipping_tax_amount" => 12 * 0.25,
            "shipping_incl_tax" => 12 * 1.25,
            "subtotal" => 1337,
            "subtotal_inc_tax" => 1337 * 1.15,
            "tax_amount" => 1337 * 0.25,
            "grand_total" => (1337 + 12) * 1.25,

            "total_qty_ordered" => 2,
            "customer_is_guest" => 0,

            "base_shipping_discount_amount" => 0,

            "weight" => 3.14,

            "customer_email" => "test@example.com",
            "customer_firstname" => $customer->getFirstname(),
            "customer_lastname" => $customer->getLastname(),
            "customer_id" => $customer->getId(),

            "base_currency_code" => "SEK",
            "global_currency_code" => "SEK",
            "order_currency_code" => "SEK",

            "shipping_method" => "flatrate_flatrate",

            "store_name" => "Test Store\nTest Store Group\nTest Website",

            "total_item_count" => 2,
        ]);

        $billingAddress = $order->getBillingAddress() ?: Mage::getModel("sales/order_address");

        $billingAddress->addData([
            "postcode" => "12345",
            "lastname" => "Testsson",
            "street" => "Paradisäppelvägen 111",
            "city" => "Ankeborg",
            "email" => "test@example.com",
            "telephone" => "0123456789",
            "country_id" => "SE",
            "firstname" => "Test",
        ]);

        $order->setBillingAddress($billingAddress);

        $shippingAddress = $order->getShippingAddress() ?: Mage::getModel("sales/order_address");

        $shippingAddress->addData([
            "postcode" => "12345",
            "lastname" => "Testsson",
            "street" => "Paradisäppelvägen 111",
            "city" => "Ankeborg",
            "email" => "test@example.com",
            "telephone" => "0123456789",
            "country_id" => "SE",
            "firstname" => "Test",
        ]);

        $order->setShippingAddress($shippingAddress);

        $payment = $order->getPayment() ?: Mage::getModel("sales/order_payment");

        $payment->addData([
            "method" => "checkmo",
            "base_shipping_amount" => 12,
            "base_shipping_captured" => 12,
            "base_amount_authorized" => (1337 + 12) * 1.25,
            "base_amount_captured" => (1337 + 12) * 1.25,
            "base_amount_ordered" => (1337 + 12) * 1.25,
            "base_amount_paid" => (1337 + 12) * 1.25,
            "base_amount_paid_online" => (1337 + 12) * 1.25,
        ]);

        $items = [];

        foreach($order->getAllItems() as $i) {
            $items[$i->getSku()] = $i;
        }

        $items["test-simple"] = $items["test-simple"] ?? Mage::getModel("sales/order_item");
        $items["test-simple"]->addData([
            "store_id" => $store->getId(),
            "website_ids" => [$store->getWebsiteId()],
            "product_id" => $simple->getId(),
            "product_type" => "simple",
            "qty_ordered" => 1,
            "tax_percent" => 25,
            "is_virtual" => 0,
            "sku" => "test-simple",
            "name" => $simple->getName(),
            "description" => $simple->getDescription(),
            "price" => 337,
            "price_inc_tax" => 337 * 1.25,
            "row_total" => 337,
            "row_total_inc_tax" => 337 * 1.25,
            "tax_amount" => 337 * 0.25,
            "base_price" => 337,
            "base_price_inc_tax" => 337 * 1.25,
            "base_row_total" => 337,
            "base_row_total_inc_tax" => 337 * 1.25,
            "base_tax_amount" => 337 * 0.25,
        ])->setProduct($simple);

        $items["test-config"] = $items["test-config"] ?? Mage::getModel("sales/order_item");
        $items["test-config"]->addData([
            "store_id" => $store->getId(),
            "website_ids" => [$store->getWebsiteId()],
            "product_id" => $config->getId(),
            "product_type" => "configurable",
            "qty_ordered" => 1,
            "tax_percent" => 25,
            "is_virtual" => 0,
            "sku" => "test-config",
            "name" => $config->getName(),
            "description" => $config->getDescription(),
            "price" => 137,
            "price_inc_tax" => 137 * 1.25,
            "row_total" => 137,
            "row_total_inc_tax" => 137 * 1.25,
            "tax_amount" => 137 * 0.25,
            "base_price" => 137,
            "base_price_inc_tax" => 137 * 1.25,
            "base_row_total" => 137,
            "base_row_total_inc_tax" => 137 * 1.25,
            "base_tax_amount" => 137 * 0.25,
        ]);

        $items["test-config-child-1"] = $items["test-config-child-1"] ?? Mage::getModel("sales/order_item");
        $items["test-config-child-1"]->addData([
            "store_id" => $store->getId(),
            "website_ids" => [$store->getWebsiteId()],
            "product_id" => $configChild1->getId(),
            "product_type" => "simple",
            "qty_ordered" => 1,
            "tax_percent" => 25,
            "is_virtual" => 0,
            "sku" => "test-config-child-1",
            "name" => $configChild1->getName(),
            "description" => $configChild1->getDescription(),
            "price" => 137,
            "price_inc_tax" => 137 * 1.25,
            "row_total" => 137,
            "row_total_inc_tax" => 137 * 1.25,
            "tax_amount" => 137 * 0.25,
            "base_price" => 137,
            "base_price_inc_tax" => 137 * 1.25,
            "base_row_total" => 137,
            "base_row_total_inc_tax" => 137 * 1.25,
            "base_tax_amount" => 137 * 0.25,
        ]);
        $items["test-config-child-1"]->setParentItem($items["test-config"]);

        $items["test-bundle-select"] = $items["test-bundle-select"] ?? Mage::getModel("sales/order_item");
        $items["test-bundle-select"]->addData([
            "store_id" => $store->getId(),
            "website_ids" => [$store->getWebsiteId()],
            "product_id" => $bundle->getId(),
            "product_type" => "bundle",
            "qty_ordered" => 1,
            "tax_percent" => 25,
            "is_virtual" => 0,
            "sku" => "test-bundle-select",
            "name" => $bundle->getName(),
            "description" => $bundle->getDescription(),
            "price" => 437,
            "price_inc_tax" => 437 * 1.25,
            "row_total" => 437,
            "row_total_inc_tax" => 437 * 1.25,
            "tax_amount" => 437 * 0.25,
            "base_price" => 437,
            "base_price_inc_tax" => 437 * 1.25,
            "base_row_total" => 437,
            "base_row_total_inc_tax" => 437 * 1.25,
            "base_tax_amount" => 437 * 0.25,
        ]);

        $items["test-bundle-select-2"] = $items["test-bundle-select-1"] ?? Mage::getModel("sales/order_item");
        $items["test-bundle-select-2"]->addData([
            "store_id" => $store->getId(),
            "website_ids" => [$store->getWebsiteId()],
            "product_id" => $bundleSelect2->getId(),
            "product_type" => "simple",
            "qty_ordered" => 1,
            "tax_percent" => 25,
            "is_virtual" => 0,
            "sku" => "test-bundle-select-2",
            "name" => $bundleSelect2->getName(),
            "description" => $bundleSelect2->getDescription(),
            "price" => 137,
            "price_inc_tax" => 137 * 1.25,
            "row_total" => 137,
            "row_total_inc_tax" => 137 * 1.25,
            "tax_amount" => 137 * 0.25,
            "base_price" => 137,
            "base_price_inc_tax" => 137 * 1.25,
            "base_row_total" => 137,
            "base_row_total_inc_tax" => 137 * 1.25,
            "base_tax_amount" => 137 * 0.25,
        ]);
        $items["test-bundle-select-2"]->setParentItem($items["test-bundle-select"]);

        foreach($items as $i) {
            $order->addItem($i);
        }

        $order->save();
    }
}
