<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

/**
 * @psalm-type BundleOptions Array<string, Array<string> | string>
 */
class MageQL_Sales_Model_Product_Buyrequest_Bundle extends MageQL_Sales_Model_Product_Buyrequest {
    /**
     * Attempts to generate a valid buy-request for a bundle using default
     * selections, will return null if there are required options without
     * default selection(s).
     */
    public static function fromProduct(
        Mage_Catalog_Model_Product $product,
        Mage_Core_Model_Store $store
    ): ?MageQL_Sales_Model_Product_Buyrequest {
        if (self::requiresSelection($product, $store)) {
            return null;
        }

        return new self($product);
    }

    public static function getOptionSelections(
        Mage_Bundle_Model_Option $option,
        Mage_Core_Model_Store $store
    ): Mage_Bundle_Model_Resource_Selection_Collection {
        /**
         * @var Mage_Bundle_Model_Resource_Selection_Collection
         */
        $selections = Mage::getResourceModel("bundle/selection_collection");

        $selections->setOptionIdsFilter([$option->getId()]);

        // No visibility filter here since bundle option selections can be invisible
        $selections->addStoreFilter($store);
        $selections->addMinimalPrice();
        $selections->joinPrices((int)$store->getWebsiteId());

        return $selections;
    }

    public static function requiresSelection(
        Mage_Catalog_Model_Product $product,
        Mage_Core_Model_Store $store
    ): bool {
        /**
         * @var Mage_Bundle_Model_Product_Type
         */
        $instance = $product->getTypeInstance(true);
        $options = $instance->getOptions($product);

        foreach($options as $opt) {
            if($opt->getType() === "hidden" || !$opt->getRequired()) {
                continue;
            }

            $hasSelection = false;

            foreach(self::getOptionSelections($opt, $store) as $sel) {
                if($sel->getIsDefault() && $sel->getSelectionQty() > 0) {
                    $hasSelection = true;
                }
            }

            if( ! $hasSelection) {
                return true;
            }
        }

        return false;
    }
}
