<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class MageQL_Sales_Model_Payment_Free extends MageQL_Sales_Model_Payment_Abstract {
    public function getCode(): string {
        return "free";
    }

    public function getMethodTypeName(): string {
        return "Free";
    }

    public function getPaymentMethodFields(Registry $registry): array {
        return [];
    }

    public function getQuotePaymentFields(Registry $registry): array {
        return [];
    }

    public function getMutateSetQuotePaymentFields(Registry $registry): array {
        return [
            "result" => $this->field(
                $this->getMutationResultType()."!",
                "Result of attempting to set the payment method to Free"
            )
                // Simple result, we either succeed or fail
                ->setResolver("MageQL\\forwardResolver"),
        ];
    }

    public function mutateSetPaymentMethod(Mage_Sales_Model_Quote $quote, array $args, $ctx, ResolveInfo $info) {
        $model = Mage::getSingleton("mageql_sales/quote");

        try {
            $model->importPaymentData($quote, "free", []);
            $model->saveSessionQuote();

            return self::SUCCESS;
        }
        catch(Mage_Core_Exception $e) {
            return $this->translatePaymentError($e);
        }
    }
}
