<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Sales_Model_Payment extends Mage_Core_Model_Abstract {

    public static function resolveIsAvailable(Mage_Payment_Model_Method_Abstract $src) {
        $quote = Mage::getSingleton("mageql_sales/quote")->getQuote();

        return $src->isApplicableToQuote($quote, Mage_Payment_Model_Method_Abstract::CHECK_USE_FOR_COUNTRY
            | Mage_Payment_Model_Method_Abstract::CHECK_USE_FOR_CURRENCY
            | Mage_Payment_Model_Method_Abstract::CHECK_ORDER_TOTAL_MIN_MAX
            // TODO: Should this be here?
            | Mage_Payment_Model_Method_Abstract::CHECK_ZERO_TOTAL);
    }
}
