<?php

declare(strict_types=1);

class MageQL_Sales_Model_Order_Result extends MageQL_Sales_Model_Order_AbstractResult {
    const SUCCESS = "success";

    protected $order;
    protected $paymentRedirectUrl = null;

    public function __construct(Mage_Sales_Model_Order $order) {
        $this->order = $order;
    }

    public function getResult(): string {
        return self::SUCCESS;
    }

    public function setPaymentRedirectUrl(string $url): self {
        $this->paymentRedirectUrl = $url;
    }

    public function getPaymentRedirectUrl(): ?string {
        return $this->paymentRedirectUrl;
    }

    public function getOrder(): Mage_Sales_Model_Order {
        return $this->order;
    }
}
