<?php

declare(strict_types=1);

/**
 * @psalm-type ProductSortInput array{
 *   code: string,
 *   order: MageQL_Catalog_Model_Sort::ORDER_ASC|MageQL_Catalog_Model_Sort::ORDER_DESC,
 * }
 */
class MageQL_Sales_Model_Wishlist_Collection
    extends MageQL_Catalog_Model_Product_AbstractSortableCollection {
    const DEFAULT_SORT = [
        // This should be a sortable attribute at all times (is one by default)
        // and therefore we do not need to add it to the possible sorts
        "code" => "name",
        "order" => MageQL_Catalog_Model_Sort::ORDER_ASC,
    ];

    public function __construct(Mage_Core_Model_Store $store, Mage_Customer_Model_Customer $customer) {
        $collection = Mage::getModel('catalog/product')->getCollection();

        $subquery = new Zend_Db_Expr(sprintf(
            "SELECT `w2`.`product_id` FROM `wishlist` `w1` JOIN `wishlist_item` `w2` ON `w2`.`wishlist_id` = `w1`.`wishlist_id` WHERE `w1`.`customer_id` = %d AND `w2`.`store_id` = %d",
            (int)$customer->getId(),
            $store->getId()
        ));
        $collection->getSelect()->where("`e`.`entity_id` IN (?)", $subquery);

        // Just plain URLs here since we do not have a category
        $collection->addUrlRewrite();

        parent::__construct($collection, $store);
    }

    /**
     * @return ProductSortInput
     */
    public function getDefaultSort(): array {
        return self::DEFAULT_SORT;
    }
}
