<?php

declare(strict_types=1);

use MageQL\ClientException;
use GraphQL\Error\ClientAware;

/**
 * Exception triggered when an error occurs while submitting an order.
 *
 * This is special since it might not always occur in the specific mutation
 * which handles the errors.
 */
class MageQL_Sales_SubmitOrderException
    extends ClientException
    implements ClientAware {
    const NO_ITEMS = "errorNoItems";
    const NO_PAYMENT_METHOD = "errorNoPaymentMethod";
    const PAYMENT_NOT_AVAILABLE = "errorPaymentNotAvailable";
    const INVALID_PAYMENT_METHOD = "errorInvalidPaymentMethod";
    const INVALID_EMAIL_ADDRESS = "errorInvalidEmailAddress";
    const NO_SHIPPING_METHOD = "errorNoShippingMethod";
    const SHIPPING_ADDRESS_VALIDATION_FAILED = "errorShippingAddressValidationFailed";
    const BILLING_ADDRESS_VALIDATION_FAILED = "errorBillingAddressValidationFailed";
    const PRODUCTS_NOT_AVAILABLE = "errorProductsNotAvailable";
    const FRAUD_SHOP = "errorFraudShop";
    const FRAUD_ORDER = "errorFraudOrder";
    const FRAUD_PRODUCT = "errorFraudProduct";
    const FRAUD_BLACKLIST = "errorFraudBlacklist";

    /**
     * @var string
     */
    protected $errorCode;

    public function __construct(string $errorCode) {
        $this->errorCode = $errorCode;

        // TODO: Translate to human readable too?
        parent::__construct($errorCode);
    }

    public function getErrorCode(): string {
        return $this->errorCode;
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "mageql_sales";
    }

    public function getExtensions(): array {
        return [
            "code" => $this->errorCode,
            // TODO: Propagate more stuff here when we have it
        ];
    }
}
