<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;

class MageQL_Sales_InvalidCountryCodeException
    extends Exception
    implements ClientAware {
    public function __construct(string $countryCode) {
        parent::__construct(sprintf(
            "The country code '%s' is invalid and cannot be used to place an order.",
            $countryCode
        ));
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "mageql";
    }
}
