<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

class MageQL_Sales_Model_BuyRequest_Product extends MageQL_Sales_Model_BuyRequest {
    /**
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    /**
     * @var array<int, int|string>
     */
    protected $customOptions = [];

    /**
     * @param Mage_Catalog_Model_Product $product
     * @param array<int, int|string> $customOptions
     */
    public function __construct(
        Mage_Catalog_Model_Product $product,
        array $customOptions = []
    ) {
        // TODO: modify to account for more custom-option types
        $this->product = $product;
        $this->customOptions = $customOptions;
    }

    public function getProduct(): Mage_Catalog_Model_Product {
        return $this->product;
    }

    public function getBuyRequest(): array {
        $data = [];

        if (!empty($this->customOptions)) {
            $data["options"] = [];
            foreach ($this->customOptions as $key => $value) {
                $data["options"][(string)$key] = (string)$value;
            }
        }

        return $data;
    }

    public function getPayload(): array {
        $data = [
            "p" => (int)$this->product->getId(),
        ];

        if (!empty($this->customOptions)) {
            $data["o"] = [];
            foreach ($this->customOptions as $key => $value) {
                $data["o"][(string)$key] = (string)$value;
            }
        }

        return $data;
    }
}
