<?php

declare(strict_types=1);

class MageQL_Sales_Helper_Data extends Mage_Core_Helper_Abstract {
    const CONFIG_ALLOW_PLACEHOLDER_BILLING_ADDRESS = "checkout/options/allow_placeholder_address";
    const CONFIG_REQUIRE_EMAIL = "checkout/options/require_email";

    public function getAllowPlaceholderBillingAddress(Mage_Core_Model_Store $store): bool {
        return (bool)$store->getConfig(self::CONFIG_ALLOW_PLACEHOLDER_BILLING_ADDRESS);
    }

    public function getRequireEmail(Mage_Core_Model_Store $store): bool {
        return (bool)$store->getConfig(self::CONFIG_REQUIRE_EMAIL);
    }
}
