<?php

declare(strict_types=1);

class MageQL_Sales_Model_BuyRequest_Product_Bundle extends MageQL_Sales_Model_BuyRequest_Product {
    /**
     * @var array
     */
    protected $bundleOption;

    /**
     * @var array
     */
    protected $bundleOptionQty;

    /**
     * @param Array<string, float> $bundleOptionQty
     */
    public function __construct(
        Mage_Catalog_Model_Product $product,
        array $bundleOption,
        array $bundleOptionQty
    ) {
        $this->product = $product;
        $this->bundleOption = $bundleOption;
        $this->bundleOptionQty = $bundleOptionQty;
    }

    public function getBuyRequest(): array {
        return [
            "bundle_option" => $this->bundleOption,
            "bundle_option_qty" => $this->bundleOptionQty,
        ];
    }

    public function getPayload(): array {
        return [
            "p" => $this->product->getId(),
        ];
    }
}
