<?php

declare(strict_types=1);

class MageQL_Sales_Model_Order_Result extends MageQL_Sales_Model_Order_AbstractResult {
    const SUCCESS = "success";

    /**
     * @var Mage_Sales_Model_Order
     */
    protected $order;
    /**
     * @var ?string
     */
    protected $paymentRedirectUrl = null;

    public function __construct(Mage_Sales_Model_Order $order) {
        $this->order = $order;
    }

    public function getResult(): string {
        return self::SUCCESS;
    }

    public function setPaymentRedirectUrl(string $url): self {
        $this->paymentRedirectUrl = $url;

        return $this;
    }

    public function getPaymentRedirectUrl(): ?string {
        return $this->paymentRedirectUrl;
    }

    public function getOrder(): Mage_Sales_Model_Order {
        return $this->order;
    }
}
