<?php

declare(strict_types=1);

class MageQL_Sales_Model_Order_Error extends MageQL_Sales_Model_Order_AbstractResult {
    const NO_ITEMS = "errorNoItems";
    const NO_PAYMENT_METHOD = "errorNoPaymentMethod";
    const PAYMENT_NOT_AVAILABLE = "errorPaymentNotAvailable";
    const INVALID_PAYMENT_METHOD = "errorInvalidPaymentMethod";
    const INVALID_EMAIL_ADDRESS = "errorInvalidEmailAddress";
    const NO_SHIPPING_METHOD = "errorNoShippingMethod";
    const SHIPPING_ADDRESS_VALIDATION_FAILED = "errorShippingAddressValidationFailed";
    const BILLING_ADDRESS_VALIDATION_FAILED = "errorBillingAddressValidationFailed";

    /**
     * @var string
     */
    protected $result;

    public function __construct(string $result) {
        $this->result = $result;
    }

    public function getResult(): string {
        return $this->result;
    }
}
