<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class MageQL_LoginAsCustomer_Model_Schema extends MageQL_Core_Model_Schema_Abstract {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
        case "MutateAdminLoginAsCustomerResult":
            return $this->object("Object representing the result of an adminLoginAsCustomer mutation.");

        case "MutateAdminLoginAsCustomerResultType":
            return $this->enum("Type of result from adminLoginAsCustomer mutation.", [
                MageQL_LoginAsCustomer_Model_Customer::SUCCESS => [
                    "description" => "Customer was logged in successfully.",
                ],
                MageQL_LoginAsCustomer_Model_Customer::INVALID_KEY => [
                    "description" => "The supplied key is not valid.",
                ],
                MageQL_LoginAsCustomer_Model_Customer::EXPIRED_KEY => [
                    "description" => "The supplied key is expired.",
                ],
                MageQL_LoginAsCustomer_Model_Customer::CUSTOMER_NOT_FOUND => [
                    "description" => "The customer could not be found in this store.",
                ],
            ]);
        }

        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "MutateAdminLoginAsCustomerResult":
            return [
                "result" => $this->field("MutateAdminLoginAsCustomerResultType!", "The result type")
                    ->setResolver(function($src) {
                        // Login is successful if we have an object here
                        return is_string($src) ? $src : MageQL_LoginAsCustomer_Model_Customer::SUCCESS;
                    }),
                "customer" => $this->field("Customer", "Present if it is a success")
                    ->setResolver(function($src) {
                        return is_string($src) ? null : $src;
                    }),
            ];

        case "Mutation":
            return [
                "adminLoginAsCustomer" => $this->field("MutateAdminLoginAsCustomerResult!", "Attempt to log in as a customer using a key")
                    ->addArgument("key", $this->argument("ID!", "The generated key provided by the admin interface"))
                    ->addArgument("redirect", $this->argument("Boolean", "If to redirect the user upon success, note that this will not be compatible with query batching or reading the result")->setDefaultValue(false))
                    ->setResolver("MageQL_LoginAsCustomer_Model_Customer::mutateAdminLogin"),
            ];
        }

        return [];
    }
}
