<?php

declare(strict_types=1);

class MageQL_LoginAsCustomer_Model_Observer extends Mage_Core_Model_Abstract {
    public function injectLoginAsCustomerButton($observer) {
        $block = $observer->getEvent()->getBlock();

        if( ! $block instanceof Mage_Adminhtml_Block_Customer_Edit) {
            return;
        }

        $customer =  Mage::registry("current_customer");

        if($customer && $customer->getId()) {
            $website = Mage::app()->getWebsite($customer->getWebsiteId());
            $baseUrl = $website->getConfig("web/unsecure/base_url");

            $url = $this->getLoginAsCustomerUrl($customer, $baseUrl);

            $block->addButton("loginAsCustomer", [
                "label" => Mage::helper("customer")->__("Login as Customer"),
                "onclick" => "popWin('$url', '_blank')",
                "class" => "loginAsCustomer",
            ], 0);

            if(Mage::getIsDeveloperMode()) {
                $localUrl = $this->getLoginAsCustomerUrl($customer, "http://localhost:3000/");

                $block->addButton("loginAsCustomerDev", [
                    "label" => Mage::helper("customer")->__("Locally Login as Customer"),
                    "onclick" => "popWin('$localUrl', '_blank')",
                    "title" => "Will redirect to http://localhost/",
                    "class" => "loginAsCustomer",
                ], 0);
            }
        }
    }

    public function getLoginAsCustomerUrl($customer, $baseUrl) {
        if(Mage::getSingleton("customer/config_share")->isWebsiteScope()) {
            return Mage::helper("adminhtml")->getUrl("*/LoginAsCustomerGraphQL/login/", [
                "customer_id" => $customer->getId(),
                "base_url" => $baseUrl,
            ]);
        }
    }
}
