<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class MageQL_LoginAsCustomer_Model_Customer extends Mage_Core_Model_Abstract {
    /**
     * Seconds.
     */
    const VALID_TIMEFRAME = 5;
    const SUCCESS = "success";
    const INVALID_KEY = "errorInvalidKey";
    const EXPIRED_KEY = "errorExpiredKey";
    const CUSTOMER_NOT_FOUND = "errorCustomerNotFound";

    public static function mutateAdminLogin($src, array $args, $ctx, $info) {
        $store = $ctx->getStore();
        $helper = Mage::helper("mageql_loginascustomer");
        $info = $helper->decode($args["key"]);

        if(empty($info["cid"])) {
            return self::INVALID_KEY;
        }

        if(empty($info["t"])) {
            return self::INVALID_KEY;
        }

        $tDiff = abs(time() - (int)$info["t"]);

        if($tDiff > self::VALID_TIMEFRAME) {
            return self::EXPIRED_KEY;
        }

        $session = Mage::getSingleton("customer/session");

        if($args["redirect"]) {
            $url = $store->getBaseUrl(Mage_Core_Model_Store::URL_TYPE_LINK, true);

            Mage::app()->getResponse()->setRedirect($url);
        }

        // TODO: Clear user session first
        if($session->loginById($info["cid"])) {
            // Customer is loaded now
            return $session->getCustomer();
        }

        return self::CUSTOMER_NOT_FOUND;
    }
}
