<?php

declare(strict_types=1);

class MageQL_LoginAsCustomer_Helper_Data extends Mage_Core_Helper_Abstract {
    /**
     * Url-friendly version of `base64_encode`
     */
    public function base64url_encode(string $data): string {
        return rtrim(strtr(base64_encode($data), "+/", "-_"), "=");
    }

    /**
     * Url-friendly version of `base64_decode`
     */
    public function base64url_decode(string $data): string {
        return base64_decode(str_pad(strtr($data, "-_", "+/"), strlen($data) % 4, "=", STR_PAD_RIGHT));
    }

    public function encode(array $data): string {
        $helper = Mage::helper("core");

        return $this->base64url_encode($helper->encrypt(serialize($data)));
    }

    public function decode(string $encoded) {
        $helper = Mage::helper("core");
        $data = $helper->decrypt($this->base64url_decode($encoded));

        return unserialize($data);
    }

    public function createQuery(string $key, bool $redirect): string {
        return sprintf(
            "mutation{adminLoginAsCustomer(key:%s,redirect:%s){result}}",
            json_encode($key),
            json_encode($redirect)
        );
    }
}
