<?php

declare(strict_types=1);

class MageQL_LoginAsCustomer_Adminhtml_LoginAsCustomerGraphQLController extends Mage_Adminhtml_Controller_Action {
    public function loginAction(): void {
        // We are in admin, we trust this
        $baseUrl = $this->getRequest()->getParam("base_url");
        $customerId = $this->getRequest()->getParam("customer_id");
        $helper = Mage::helper("mageql_loginascustomer");

        $data = [
            "cid" => $customerId,
            "t" => time(),
        ];

        $key = $helper->encode($data);
        $query = $helper->createQuery($key, true);

        $body = '<!doctype html>
<html>
    <head lang="en">
        <meta charset="UTF-8">
    </head>
    <body>
        <form name="loginform" action="'.htmlspecialchars($baseUrl."graphql", ENT_QUOTES).'" method="POST">
            <input type="hidden" name="query" value="'.htmlspecialchars($query, ENT_QUOTES).'" />
            <button type="submit">Login</button>
        </form>
        <script type="application/javascript">
            document.loginform.submit();
        </script>
    </body>
</html>';

        $response = $this->getResponse();

        $response->clearHeaders();
        $response->setHttpResponseCode(200);
        $response->setBody($body);
    }
}
