<?php

declare(strict_types=1);

class MageQL_LoginAsCustomer_Model_Observer extends Mage_Core_Model_Abstract {
    public function injectLoginAsCustomerButton(Varien_Event_Observer $observer): void {
        $block = $observer->getEvent()->getBlock();

        if( ! $block instanceof Mage_Adminhtml_Block_Customer_Edit) {
            return;
        }

        /**
         * @var ?Mage_Customer_Model_Customer
         */
        $customer = Mage::registry("current_customer");

        if($customer && $customer->getId()) {
            $website = Mage::app()->getWebsite($customer->getWebsiteId());
            $baseUrl = $website->getConfig("web/unsecure/base_url");

            $url = $this->getLoginAsCustomerUrl($customer, $baseUrl);

            $block->addButton("loginAsCustomer", [
                "label" => Mage::helper("customer")->__("Login as Customer"),
                "onclick" => "popWin('$url', '_blank')",
                "class" => "loginAsCustomer",
            ], 0);

            if(Mage::getIsDeveloperMode()) {
                $localUrl = "http://localhost:3000/";
                $localButtonUrl = $this->getLoginAsCustomerUrl($customer, $localUrl);

                $block->addButton("loginAsCustomerDev", [
                    "label" => Mage::helper("customer")->__("Locally Login as Customer"),
                    "onclick" => "popWin('$localButtonUrl', '_blank')",
                    "title" => "Will redirect to $localUrl",
                    "class" => "loginAsCustomer",
                ], 0);
            }
        }
    }

    public function getLoginAsCustomerUrl(Mage_Customer_Model_Customer $customer, string $baseUrl): ?string {
        if(Mage::getSingleton("customer/config_share")->isWebsiteScope()) {
            return Mage::helper("adminhtml")->getUrl("*/LoginAsCustomerGraphQL/login/", [
                "customer_id" => $customer->getId(),
                "base_url" => rawurlencode($baseUrl),
            ]);
        }

        return null;
    }
}
