<?php

declare(strict_types=1);

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class MageQL_LoginAsCustomer_Model_Customer extends Mage_Core_Model_Abstract {
    /**
     * Seconds.
     */
    const VALID_TIMEFRAME = 5;
    const SUCCESS = "success";
    const INVALID_KEY = "errorInvalidKey";
    const EXPIRED_KEY = "errorExpiredKey";
    const CUSTOMER_NOT_FOUND = "errorCustomerNotFound";

    /**
     * @param mixed $unusedSrc
     * @return Mage_Customer_Model_Customer|string
     */
    public static function mutateAdminLogin($unusedSrc, array $args, MageQL_Core_Model_Context $ctx) {
        $store = $ctx->getStore();
        $helper = Mage::helper("mageql_loginascustomer");
        $info = $helper->decode($args["key"]);

        if(empty($info["cid"])) {
            return self::INVALID_KEY;
        }

        if(empty($info["t"])) {
            return self::INVALID_KEY;
        }

        $tDiff = abs(time() - (int)$info["t"]);

        if($tDiff > self::VALID_TIMEFRAME) {
            return self::EXPIRED_KEY;
        }

        $session = Mage::getSingleton("customer/session");

        // Clear old checkout session to prevent merging of sessions addresses and quotes.
        Mage::getSingleton('checkout/session')->clear();

        if( ! $session->loginById($info["cid"])) {
            // Customer is loaded now
            return self::CUSTOMER_NOT_FOUND;
        }

        if($args["redirect"]) {
            $url = $store->getBaseUrl(Mage_Core_Model_Store::URL_TYPE_LINK, true);

            Mage::app()->getResponse()->setRedirect($url);
        }

        return $session->getCustomer();
    }
}
