<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class MageQL_Cms_Model_Schema_Default extends MageQL_Core_Model_Schema_Abstract {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
        case "CmsPage":
            return $this->object("CMS Page")
                        ->setResolveField("MageQL\\defaultVarienObjectResolver");

        case "CmsBlock":
            return $this->object("CMS Block")
                        ->setResolveField("MageQL\\defaultVarienObjectResolver");

        case "RouteCmsPage":
            return $this->object("An object containing a CMS page")
                ->setInterfaces(["Route"]);
        }

        return null;
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
        case "CmsBlock":
            return [
                "content" => $this->field("String!", "Content")
                    ->setResolver("MageQL_Cms_Model_Block::resolveContent"),
                "title" => $this->field("String!", "Block title"),
            ];

        case "CmsPage":
            return [
                "content" => $this->field("String!", "Content")
                    ->setResolver("MageQL_Cms_Model_Page::resolveContent"),
                "contentHeading" => $this->field("String", "Content heading"),
                "metaDescription" => $this->field("String", "Meta description"),
                "metaKeywords" => $this->field("String", "Meta keywords"),
                "title" => $this->field("String!", "Page title"),
                "url" => $this->field("String!", "Absolute URL to the page")
                    ->setResolver("MageQL_Cms_Model_Page::resolveUrl"),
            ];

        case "Query":
            return [
                "cmsBlock" => $this->field("CmsBlock", "A CMS block identified by its identifier")
                    ->addArgument("identifier", $this->argument("String!", "Cms block identifier (slug)"))
                    ->setResolver("MageQL_Cms_Model_Block::resolve"),
                "cmsPage" => $this->field("CmsPage", "A CMS page identified by its identifier")
                    ->addArgument("identifier", $this->argument("String!", "Cms page identifier (slug)"))
                    ->setResolver("MageQL_Cms_Model_Page::resolve"),
                "cmsPageNav" => $this->field("[CmsPage!]!", "Pages to include in a navigation menu")
                    ->setResolver("MageQL_Cms_Model_Page::resolveNav"),
            ];

        case "RouteCmsPage":
            return [
                "type" => $this->field("RouteType!", "Type of route")
                    ->setResolver("MageQL_Cms_Model_Page::resolveRouteType"),
                "cmsPage" => $this->field("CmsPage!", "The CMS Page")
                    ->setResolver("MageQL\\forwardResolver"),
            ];
        }

        return [];
    }

    public function getUnreachableTypes(): array {
        return [
            "RouteCmsPage",
        ];
    }
}
