<?php

declare(strict_types=1);

use MageQL\Context;

class MageQL_Cms_Model_Block {
    /**
     * @param mixed $unusedSrc
     * @param array{identifier:string} $args
     */
    public static function resolve(
        $unusedSrc,
        array $args,
        Context $ctx
    ): ?Mage_Cms_Model_Block {
        $block = Mage::getModel("cms/block");
        $blockId = (int)self::checkIdentifier($args["identifier"], $ctx->getStore()->getId());

        if( ! $blockId) {
            return null;
        }

        $block->load($blockId);

        if( ! $block->getId() || ! $block->getIsActive()) {
            return null;
        }

        return $block;
    }

    public static function resolveContent(Mage_Cms_Model_Block $src): string {
        /** @var Varien_Filter_Template */
        $processor = Mage::helper("cms")->getBlockTemplateProcessor();

        return $processor->filter($src->getContent());
    }

    /**
     * Check if page identifier exist for specific store
     * return page id if page exists
     *
     * @param string $identifier
     * @param int $storeId
     * @return string|false|null
     */
    private static function checkIdentifier($identifier, $storeId)
    {
        return Mage::getModel("mageql_cms/resource_block")->checkIdentifier($identifier, $storeId);
    }
}
