<?php

declare(strict_types=1);

use Spatie\Snapshots\MatchesSnapshots;

use Crossroads\Magento\Test\Integration\TestCase;
use Crossroads\Magento\Test\Integration\Request;

/**
 * @runTestsInSeparateProcesses
 * @preserveGlobalState disabled
 */
class CmsBlockTest extends TestCase {
    use MatchesSnapshots;

    public function setUp(): void {
        parent::setUp();

        // Set up for this test
        $this->initMagento();

        $storeId = Mage::app()->getStore()->getId();
        $defaultStoreId = Mage::app()->getStore("default")->getId();
        $block = Mage::getModel("cms/block");

        Mage::getModel("cms/block")->addData([
            "identifier" => "content-block",
            "title" => "Block Wrong Store",
            "content" => "Content in block, but wrong store",
            "stores" => [$defaultStoreId],
        ])->save();

        Mage::getModel("cms/block")->addData([
            "identifier" => "content-block",
            "title" => "Block",
            "content" => "Content in block",
            "stores" => [$storeId],
        ])->save();
    }

    public function testContentBlock() {
        $resp = $this->runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
    cmsBlock (identifier: "content-block") {
        title,
        content
    }
}'));

        $this->assertEquals("application/json; charset=utf-8", $resp->getHeader("Content-Type"));

        $this->assertMatchesJsonSnapshot($resp->getBody());
    }
}