<?php

declare(strict_types=1);

class MageQL_Cms_Model_Observer extends Mage_Core_Model_Abstract {
    public function editTabContentPrepareForm(Varien_Event_Observer $observer): void {
        $form = $observer->getEvent()->getForm();
        $model = Mage::registry("cms_page");

        $fieldset = $form->getElement("base_fieldset");

        if($fieldset) {
            $fieldset->addField("include_in_menu", "select", [
                "name"     => "include_in_menu",
                "label"    => Mage::helper("cms")->__("Include in Navigation Menu"),
                "title"    => Mage::helper("cms")->__("Include in Navigation Menu"),
                "note"     => Mage::helper("cms")->__("Will be ignored if global config is set to \"No\", which is default value."),
                "values"   => [
                    "1" => Mage::helper("adminhtml")->__("Yes"),
                    "0" => Mage::helper("adminhtml")->__("No")
                ],
                "value" => $model->getIncludeInMenu(),
            ]);
        }
    }
}
