<?php

declare(strict_types=1);

class MageQL_Catalog_Model_Product_Bundle_Price extends MageQL_Core_Model_Price_Abstract {
    /**
     * @readonly
     * @var Mage_Catalog_Model_Product
     */
    protected $product;

    /**
     * @var ?float
     */
    private $exVat = null;
    /**
     * @var ?float
     */
    private $incVat = null;

    public function __construct(Mage_Catalog_Model_Product $product) {
        $this->product = $product;
    }

    public function getExVat(Mage_Core_Model_Store $store): float {
        if($this->exVat === null) {
            /** @var Mage_Bundle_Model_Product_Price */
            $model = $this->product->getPriceModel();
            /** @var float */
            $this->exVat = $model->getTotalPrices($this->product, "min", false);
        }

        return $this->exVat;
    }

    public function getIncVat(Mage_Core_Model_Store $store): float {
        if($this->incVat === null) {
            /** @var Mage_Bundle_Model_Product_Price */
            $model = $this->product->getPriceModel();
            /** @var float */
            $this->incVat = $model->getTotalPrices($this->product, "min", true);
        }

        return $this->incVat;
    }

    public function getVat(Mage_Core_Model_Store $store): float {
        return $store->roundPrice(max(0, $this->getIncVat($store) - $this->getExVat($store)));
    }
}
