<?php

declare(strict_types=1);

class MageQL_Catalog_Model_Product_Bundle extends Mage_Core_Model_Abstract {
    /**
     * @return Array<MageQL_Catalog_Model_Product_Bundle_Option>
     */
    public static function resolveOptions(Mage_Catalog_Model_Product $src) {
        /**
         * @var Mage_Bundle_Model_Product_Type
         */
        $instance = $src->getTypeInstance(true);
        $options = $instance->getOptions($src);

        usort($options, function(Mage_Bundle_Model_Option $a, Mage_Bundle_Model_Option $b) {
            return $b->getPosition() - $a->getPosition();
        });

        return array_values(array_map(
            function($o) use($src): MageQL_Catalog_Model_Product_Bundle_Option {
                return new MageQL_Catalog_Model_Product_Bundle_Option($o, $src);
            },
            array_filter($options, "MageQL_Catalog_Model_Product_Bundle_Option::isVisibleOption")
        ));
    }
}
