<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;
use MageQL\Context;

class MageQL_Catalog_Model_Attributes_Image_Category extends MageQL_Core_Model_Attributes_Image_Abstract {
    /**
     * @var Mage_Catalog_Model_Category
     */
    protected $src;
    /**
     * @var string
     */
    protected $attrCode;
    /**
     * @var string
     */
    protected $value;

    public function __construct(
        Mage_Catalog_Model_Category $category,
        string $attrCode,
        string $value
    ) {
        $this->src = $category;
        $this->attrCode = $attrCode;
        $this->value = $value;
    }

    public function getSrc(array $args, Context $context, ResolveInfo $info): string {
        $resize = array_key_exists("height", $args) || array_key_exists("width", $args);
        $model = Mage::getModel("mageql_catalog/category_image");

        if($resize) {
            // We need to set this before setBaseFile since that will set the
            // filename for the resized file
            if (array_key_exists("height", $args)) {
                  $model->setHeight($args["height"]);
            }

            if (array_key_exists("width", $args)) {
                  $model->setWidth($args["width"]);
            }
        }

        $model->setDestinationSubdir($this->attrCode);
        $model->setKeepFrame($args["fill"] ?? false);
        $model->setBaseFile($this->value);

        if($model->isCached()) {
            return $model->getUrl();
        }

        if($resize) {
            $model->resize();
        }

        return $model->saveFile()->getUrl();
    }
}
