<?php

declare(strict_types=1);

namespace MageQL\Catalog;

use Mage;
use Mage_Core_Model_Resource_Setup;
use Mage_Tax_Model_Config;
use Throwable;

use Crossroads\Magento\Test\Integration\MagentoManager;
use Crossroads\Magento\Test\Integration\Request;
use PHPUnit\Framework\TestCase;
use Spatie\Snapshots\MatchesSnapshots;

class InfoTest extends TestCase {
    use MatchesSnapshots;

    public function setUp(): void {
        MagentoManager::reset();
    }

    public function tearDown(): void {
        MagentoManager::logQueries();

        MagentoManager::reset();
        MagentoManager::initAdmin();

        $setupModel = new Mage_Core_Model_Resource_Setup("core_setup");

        $setupModel->deleteConfigData(Mage_Tax_Model_Config::CONFIG_XML_PATH_PRICE_INCLUDES_TAX, "websites");

        MagentoManager::reset();
    }

    public function onNotSuccessfulTest(Throwable $e): void {
        $this->tearDown();

        throw $e;
    }

    public function testCatalogPriceIncludesVat(): void {
        MagentoManager::initAdmin();

        $setupModel = new Mage_Core_Model_Resource_Setup("core_setup");

        $setupModel->setConfigData(Mage_Tax_Model_Config::CONFIG_XML_PATH_PRICE_INCLUDES_TAX, "0" , "websites", Mage::app()->getStore(MagentoManager::TESTING_STORE)->getId());

        MagentoManager::reset();

        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
            info {
                catalogPriceIncludesVat
            }
        }'));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }

    public function testCatalogPriceIncludesVat2(): void {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
            info {
                catalogPriceIncludesVat
            }
        }'));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }
}
