<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

/**
 * @template-extends MageQL_Catalog_Model_Attributes_Abstract<Mage_Catalog_Model_Category, array{code:string, backend_type:string, input:string, label:string, required:bool, not_system:bool, attribute_set:Array<string>, attribute_set_type:Array<string>, apply_to:Array<string>, show_in_detail:bool, show_in_list:bool, filterable:bool, source_model:?string }>
 */
class MageQL_Catalog_Model_Attributes_Category extends MageQL_Catalog_Model_Attributes_Abstract {
    protected function getEntityType(): string {
        return "catalog_category";
    }

    public function getBaseAttributes(): array {
        return [
            // Essentially all the hidden values for the category
            "children_count",
            "entity_id",
            "is_active",
            "is_anchor",
            "level",
            "path",
        ];
    }

    public function getFieldAttributeMap(): array {
        return [
            "url" => ["url_key", "url_path"],
        ];
    }

    protected function filterAttributeData(array $a): array {
        $a = parent::filterAttributeData($a);

        // Categories do not have any special types
        $a["apply_to"] = [];

        return $a;
    }

    /**
     * Constructor for image-wrapper.
     *
     * @param Mage_Catalog_Model_Category $src
     * @return MageQL_Core_Model_Attributes_Image_Abstract
     */
    public function createImageWrapper(
        $src,
        MageQL_Core_Model_Context $ctx,
        ResolveInfo $info,
        string $attrCode,
        string $value
    ): MageQL_Core_Model_Attributes_Image_Abstract {
        return new MageQL_Catalog_Model_Attributes_Image_Category($src, $attrCode, $value);
    }
}
