<?php

declare(strict_types=1);

/**
 * @psalm-type ProductSortInput array{
 *   code: string,
 *   order: MageQL_Catalog_Model_Sort::ORDER_ASC|MageQL_Catalog_Model_Sort::ORDER_DESC,
 * }
 */
class MageQL_Catalog_Model_Product_Collection_Category
    extends MageQL_Catalog_Model_Product_AbstractSortableCollection {
    const SORT_POSITION = "position";
    const DEFAULT_SORT = [
        "code" => self::SORT_POSITION,
        "order" => MageQL_Catalog_Model_Sort::ORDER_ASC,
    ];

    public function __construct(Mage_Catalog_Model_Category $category, Mage_Core_Model_Store $store) {
        $collection = Mage::getModel("catalog/product")->getCollection();

        // We do not yet select any attributes, that is done when we
        // fetch the data in the items resolver
        $collection->addCategoryFilter($category);
        $collection->addUrlRewrite($category->getId());

        parent::__construct($collection, $store);
    }

    /**
     * @return ProductSortInput
     */
    public function getDefaultSort(): array {
        return self::DEFAULT_SORT;
    }

    public function getSortableBy(): array {
        $list = parent::getSortableBy();

        $list[] = New MageQL_Catalog_Model_Sort(self::SORT_POSITION, Mage::helper("mageql_catalog")->__("Position"));

        return $list;
    }

    /**
     * @param ProductSortInput $sort
     */
    public function applySort(array $sort): void {
        if($sort["code"] === self::SORT_POSITION) {
            $this->collection->addAttributeToSort("position", $sort["order"]);
        }
        else {
            parent::applySort($sort);
        }
    }
}
