# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [6.3.0] - 2020-12-09
### Added
- Custom product collection filters support.

## [6.2.1] - 2020-11-05
### Fixed
- Syntax error in PHP 7.2.

## [6.2.0] - 2020-11-05
### Added
- Support for select-based custom options on simple products.

## [6.1.1] - 2020-10-30
### Fixed
- Increased minimum version of MageQL Core.

## [6.1.0] - 2020-10-30
### Added
- `ProductFilterBoolean` for boolean attribute filter.

## [6.0.4] - 2020-10-29
### Fixed
- Sort/Filter crashes when querying multiple collections in the same query.

## [6.0.3] - 2020-10-27
### Fixed
- Product price filter incorrectly adjusted for tax in available filters.

## [6.0.2] - 2020-10-12
### Fixed
- Product price filter incorrectly adjusted for tax in available filters.

## [6.0.1] - 2020-09-29
### Added
- Tests for tax when the customer is from a disallowed country.
### Changed
- Performance improvements for product listings.

## [6.0.0] - 2020-09-02
### Changed
- Updated minimum version of MageQL Core to 4.0.0.

## [5.1.5] - 2020-08-31
### Fixed
- Tests to account for translations.
- Internal type fixes.

## [5.1.4] - 2020-08-31
### Fixed
- `productsBySearch`.`totalCount` now correctly reflects the filtered total.

## [5.1.3] - 2020-07-02
### Fixed
- Add translation files to frontend namespace to make sure they are loaded.

## [5.1.2] - 2020-07-02
### Fixed
- Fixed composer map of translation files.

## [5.1.1] - 2020-06-30
### Fixed
- Added configuration for translation files.

## [5.1.0] - 2020-06-29
### Added
- Translation files for Danish, English, Finnish, Norwegian, and Swedish.

## [5.0.3] - 2020-06-23
### Changed
- Folder structure.

## [5.0.2] - 2020-06-03
### Changed
- `filtlerableBy` now only contains attributes which has available values for
  filtering which will still yield results.

## [5.0.1] - 2020-06-03
### Fixed
- Updated field documentation to rely on the schema defaults instead of listing
  the default value in documentation.

## [5.0.0] - 2020-06-02
### Added
- `filters` argument to `bestsellingProducts`, `products`, `search`,
  `recentlyViewedProducts`, `Category`.`products` to filter products in the
  collection.
- `sort` argument to `products`, `search`, and `Category`.`products` to control
  product sort order.
- `StoreInfo`.`catalogPriceIncludesVat` containing default setting for catalog
  price display.
- `PaginatedProductList` implementing `PaginatedProducts` for collections which
  cannot be sorted or filtered.
- `FilterableProductList` implementing `PaginatedProducts` containing
  `filterableBy` which details the possible ways to filter the list.
- `SortableProductList` implementing `PaginatedProducts` containing
  `filterableBy` and `sortableBy` which details the possible ways to filter and
  sort the list.
### Changed
- `PaginatedProducts` is now an interface.
- 500 products is now a maximum limit to `pageSize`.
- Moved `MageQL_Catalog_Model_Product::$LIST_ATTRIBUTE_FIELDS` property to
  `mageql_catalog` helper's `addListAttributeField` method.
- Moved `MageQL_Catalog_Model_Schema_Product::DEFAULT_PAGE_SIZE` to
  `MageQL_Catalog_Model_Product_CollectionInterface::DEFAULT_PAGE_SIZE`.
- Added `MageQL_Catalog_Model_Schema_Product::DEFAULT_PAGE` containing default
  page to show.
### Fixed
- Supplying `null` to `page`, `pageSize`, or `sort` crashed instead of using
  default values.
- Negative or zero value `pageSize` will now end up as 1.

## [4.0.1] - 2020-05-22
### Changed
- Moved test files to `test/catalog`.
- Added static analysis to test files.

## [4.0.0] - 2020-05-19
### Added
- `products` query which lists all available products.
### Changed
- `ConfigurationOptionItem` interal type is now an object of
  `MageQL_Catalog_Model_Product_Configurable_Option`.
- Dropped support for PHP 7.2 and 7.3
### Deprecated
- `productsBy`, use `products` with a `filter` parameter instead.

## [3.1.1] - 2020-04-14
### Fixed
- `PaginatedProducts`.`totalCount` is now zero when `productsBySearch` do not
  match anything.

## [3.1.0] - 2020-04-08
### Added
- New `recentlyViewedProducts` query.
- New `attributeFilter` and `priceFilter` arguments to `Categories`.`products`,
  `bestsellingProducts` and `productsBySearch` which allows consumers to filter
  the product collection based on attributes and price.
### Fixed
- Missing implementations for `ProductOption` interface.

## [3.0.0] - 2020-02-10
### Changed
- All image attributes now use the `ImageData` type.

## [2.0.1] - 2020-01-14
### Added
- `MageQL_Catalog_Model_Product::$LIST_ATTRIBUTE_FIELDS` which is a list of
  fields containing key-maps of attributes based on their attribute names and
  can be modified by other modules.
- `manufacturer` is now applied to bundles, configurable, and simple products
  in tests.

## [2.0.0] - 2019-12-16
### Added
- New `ProductOption` interface describing options and selections for
  configurable- and bundle-products.
- `ConfigurationOptionItem`.`price` containing the price for the configuration
  option.
### Changed
- `ConfigurationOptionItem`.`product` is now a `ProductOption`.
- `BundleSelection`.`product` is now a `ProductOption`.
### Removed
- `ConfigurationOptionItem`.`product` no longer contains `price` or `buyRequest`.
- `BundleSelection`.`product` no longer contains `price` or `buyRequest`.
### Fixed
- Product searches now record the number of hits.

## [1.2.0] - 2019-12-13
### Added
- Added a `categories` field to `ListProduct` and `ProductDetail` listing the
  categories in which the product is included.
### Fixed
- Route will now return null when the product and/or category fails to load
  instead of crashing.
- Category images will now display placeholders if the file cannot be found.

## [1.1.3] - 2019-11-25
### Changed
- Allow more qty variation in tests.
### Fixed
- Fixed minor type-documentation.

## [1.1.2] - 2019-11-22
### Fixed
- Bundle option in-stock and selection percent price in tests.

## [1.1.1] - 2019-11-21
### Fixed
- Bundle selection pricing is now displayed correctly.

## [1.1.0] - 2019-11-21
### Added
- Bundles are now supported.

## [1.0.4] - 2019-10-31
### Fixed
- Products are no longer reachable through their sku or route if they
  are not visible or assigned to the specific website.

## [1.0.3] - 2019-08-21
### Changed
- Refactor with types

## [1.0.2] - 2019-08-21
### Added
- Added `Category`.`parent` to allow fetching of parent category for eg.
  breadcrumbs and category-pages.
### Changed
- Use `Deferred` to improve performance on `Category`.`children` and `categoryNav`.

## [1.0.1] - 2019-08-16
### Changed
- Updated package dependencies to reference actual versions.

## [1.0.0] - 2019-08-16
### Added
- Initial version