<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;

class MageQL_Catalog_BadAttributeSortException extends Exception implements ClientAware {
    public function __construct(string $attr) {
        parent::__construct(sprintf(
            "Filter with code '%s' cannot be used for sorting.",
            $attr
        ));
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "mageql_catalog";
    }
}

