<?php

declare(strict_types=1);

class MageQL_Catalog_Model_Product_Collection_BestsellingProducts
    extends MageQL_Catalog_Model_Product_AbstractFilterableCollection {
    public function __construct(Mage_Core_Model_Store $store) {
        $collection = Mage::getModel("catalog/product")->getCollection();
        $fromDate = date("Y-m-01");

        $collection->addUrlRewrite();
        $collection->getSelect()
            ->join(
                ["aggregation" => $collection->getResource()->getTable("sales/bestsellers_aggregated_monthly")],
                sprintf("e.entity_id = aggregation.product_id AND aggregation.store_id = %d AND aggregation.period = '%s'", $store->getId(), $fromDate),
                ["SUM(aggregation.qty_ordered) AS sold_quantity"]
            )
            ->group("e.entity_id")
            ->order(array("sold_quantity DESC", "e.created_at"));

        parent::__construct($collection, $store);
    }
}
