<?php

declare(strict_types=1);

class MageQL_Catalog_Model_Product_Filter_Attribute_Range
    extends MageQL_Catalog_Model_Product_Filter_Attribute_Abstract {
    public function getTypeName(): string {
        return "ProductFilterRange";
    }

    public function getRange(): MageQL_Catalog_Model_Filter_Range {
        $conn = $this->collection->getResource()->getReadConnection();
        $select = clone $this->collection->getSelect();

        $valueCol = $this->attribute->getAttributeCode();

        $select->reset(Zend_Db_Select::COLUMNS);
        $select->reset(Zend_Db_Select::ORDER);
        $select->reset(Zend_Db_Select::LIMIT_COUNT);
        $select->reset(Zend_Db_Select::LIMIT_OFFSET);
        $select->columns([
            "min" => new Zend_Db_Expr(sprintf("MIN(%s)", $conn->quoteIdentifier($valueCol))),
            "max" => new Zend_Db_Expr(sprintf("MAX(%s)", $conn->quoteIdentifier($valueCol))),
        ]);

        $select->where(sprintf("%s IS NOT NULL", $conn->quoteIdentifier($valueCol)));

        $data = $conn->query($select)->fetch(Zend_Db::FETCH_ASSOC);

        return new MageQL_Catalog_Model_Filter_AttributeRange((float)$data["min"], (float)$data["max"]);
    }

    public function hasData(): bool {
        // Ranges should always have data
        return true;
    }
}
