<?php

declare(strict_types=1);

/**
 * @psalm-type ProductFilterInput array{
 *   code: string,
 *   value: ?string,
 *   minValue: ?float,
 *   maxValue: ?float,
 *   incVat: ?bool,
 * }
 */
interface MageQL_Catalog_Model_Product_FilterableCollectionInterface
    extends MageQL_Catalog_Model_Product_CollectionInterface {
    /**
     * @return Array<MageQL_Catalog_Model_Product_Filter_Abstract>
     */
    public function getFilterableBy(): array;

    /**
     * @param Array<ProductFilterInput> $filters
     */
    public function setFilters(array $filters): void;
}
