<?php

declare(strict_types=1);

class MageQL_Catalog_Model_Product_Collection_RecentlyViewed
    extends MageQL_Catalog_Model_Product_AbstractFilterableCollection {
    public function __construct(Mage_Customer_Model_Customer $customer, Mage_Core_Model_Store $store) {
        $collection = Mage::getModel('catalog/product')->getCollection();

        $collection->addUrlRewrite();
        $collection->getSelect()
            ->join(
                [ "rv" => "report_viewed_product_index" ],
                "rv.product_id = e.entity_id",
                 ["rv.added_at as added_at"])
            ->where(sprintf("rv.customer_id = %d AND rv.store_id = %d", $customer->getId(), $store->getId()))
            ->order("rv.added_at " . Varien_Data_Collection::SORT_ORDER_DESC);

        parent::__construct($collection, $store);
    }
}
