<?php

declare(strict_types=1);

use GraphQL\Type\Definition\ResolveInfo;

interface MageQL_Catalog_Model_Product_CollectionInterface {
    const DEFAULT_PAGE = 1;
    const DEFAULT_PAGE_SIZE = 20;
    const MAX_PAGE_SIZE = 500;

    /**
     * @return Array<Mage_Catalog_Model_Product>
     */
    public function getItems(ResolveInfo $info): array;

    public function getSize(): int;

    public function setPage(?int $page, ?int $pageSize): void;
}
