<?php

declare(strict_types=1);

class MageQL_Catalog_Model_Category_Image extends Mage_Catalog_Model_Product_Image {
    /**
     * @return string
     */
    public function getCategoryMediaBasePath() {
        return Mage::getBaseDir("media") . DS."catalog".DS."category".DS;
    }

    /**
     * @return string
     */
    public function getCategoryMediaCache() {
        return Mage::getBaseDir("media") . DS."catalog".DS."category_cache";
    }

    /**
     * @param ?string $file
     * @return $this
     */
    public function setBaseFile($file) {
        $this->_isBaseFilePlaceholder = false;

        if (($file) && (0 !== strpos($file, "/", 0))) {
            $file = "/" . $file;
        }
        $baseDir = $this->getCategoryMediaBasePath();

        if ($file) {
            if ((!$this->_fileExists($baseDir . $file)) || !$this->_checkMemory($baseDir . $file)) {
                $file = null;
            }
        }

        if( ! $file) {
            // Placeholder code from Product

            // check if placeholder defined in config
            $isConfigPlaceholder = Mage::getStoreConfig("catalog/placeholder/{$this->getDestinationSubdir()}_placeholder");
            $configPlaceholder   = "/placeholder/" . $isConfigPlaceholder;
            if ($isConfigPlaceholder && $this->_fileExists($baseDir . $configPlaceholder)) {
                $file = $configPlaceholder;
            }
            else {
                // replace file with skin or default skin placeholder
                $skinBaseDir     = Mage::getDesign()->getSkinBaseDir();
                $skinPlaceholder = "/images/catalog/product/placeholder/{$this->getDestinationSubdir()}.jpg";
                $file = $skinPlaceholder;
                if (file_exists($skinBaseDir . $file)) {
                    $baseDir = $skinBaseDir;
                }
                else {
                    $baseDir = Mage::getDesign()->getSkinBaseDir(array("_theme" => "default"));
                    if (!file_exists($baseDir . $file)) {
                        $baseDir = Mage::getDesign()->getSkinBaseDir(array("_theme" => "default", "_package" => "base"));
                    }
                }
            }
            $this->_isBaseFilePlaceholder = true;
        }

        $baseFile = $baseDir . $file;

        $this->_baseFile = $baseFile;

        if ((!$file) || (!$this->_fileExists($this->_baseFile))) {
            throw new Exception(Mage::helper("catalog")->__("Image file was not found."));
        }

        // build new filename (most important params)
        $path = array_filter([
            $this->getCategoryMediaCache(),
            Mage::app()->getStore()->getId(),
            $this->getDestinationSubdir()
        ]);
        if((!empty($this->_width)) || (!empty($this->_height)))
            $path[] = "{$this->_width}x{$this->_height}";

        // add misk params as a hash
        $miscParams = [
                ($this->_keepAspectRatio  ? "" : "non") . "proportional",
                ($this->_keepFrame        ? "" : "no")  . "frame",
                ($this->_keepTransparency ? "" : "no")  . "transparency",
                ($this->_constrainOnly ? "do" : "not")  . "constrainonly",
                $this->_rgbToString($this->_backgroundColor),
                "angle" . $this->_angle,
                "quality" . $this->_quality
        ];

        $path[] = md5(implode("_", $miscParams));

        // append prepared filename
        $this->_newFile = implode("/", $path) . $file; // the $file contains heading slash

        return $this;
    }

    /**
     * @return bool
     */
    protected function _getWatermarkFilePath()
    {
        return false;
    }

    /**
     * @return void
     */
    public function clearCache() {
        $directory = $this->getCategoryMediaCache();

        $io = new Varien_Io_File();
        $io->rmdir($directory, true);

        Mage::helper("core/file_storage_database")->deleteFolder($directory);
    }
}
