<?php

declare(strict_types=1);

use GraphQL\Error\ClientAware;

class MageQL_Catalog_BadFilterTypeException extends Exception implements ClientAware {
    public function __construct(Mage_Eav_Model_Entity_Attribute_Abstract $attr) {
        parent::__construct(sprintf(
            "Filter with code '%s' and type '%s' cannot be filtered.",
            $attr->getAttributeCode(),
            $attr->getFronendInput()
        ));
    }

    public function isClientSafe() {
        return true;
    }

    public function getCategory() {
        return "mageql_catalog";
    }
}

