<?php

declare(strict_types=1);

namespace MageQL\Catalog;

use Mage;
use Throwable;

use Crossroads\Magento\Test\Integration\MagentoManager;
use Crossroads\Magento\Test\Integration\Request;
use PHPUnit\Framework\TestCase;
use Spatie\Snapshots\MatchesSnapshots;

class MinMaxTest extends TestCase {
    use MatchesSnapshots;

    public function setUp(): void {
        MagentoManager::reset();
    }

    public function tearDown(): void {
        MagentoManager::logQueries();
    }

    public function onNotSuccessfulTest(Throwable $e): void {
        MagentoManager::logQueries();

        throw $e;
    }

    /*
    public function testProductPriceMinMax(): void {
        MagentoManager::init();

        $this->doTest(
            'query {
                products {
                    totalCount
                    collectionMinMax {
                        maxCount
                        minPrice { incVat }
                        maxPrice { incVat }
                    }
                    items {
                        sku
                        price { incVat }
                    }
                }
            }'
        );

        MagentoManager::reset();
        MagentoManager::init();
        $this->doTest(
            'query {
                products (
                    attributeFilter: [ { code:"manufacturer", value:"Manufacturer B" } ],
                    priceFilter: { minValue:10, maxValue:20 }
                ) {
                    totalCount
                    collectionMinMax {
                        maxCount
                        minPrice { incVat }
                        maxPrice { incVat }
                    }
                    items {
                        sku
                        price { incVat }
                    }
                }
            }'
        );
    }

    public function doTest($query, $debug = false) {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], $query));

        if ($debug) {
            //file_put_contents("var/log/mageql_catalog_request_result.log", $query . "\n" . $res->getBody() . "\n", FILE_APPEND);
            $this->assertEquals("", $res->getBody());
        }
        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }
     */
}