<?php

declare(strict_types=1);

use Spatie\Snapshots\MatchesSnapshots;

use PHPUnit\Framework\TestCase;
use Crossroads\Magento\Test\Integration\MagentoManager;
use Crossroads\Magento\Test\Integration\Request;
use GraphQL\Utils\SchemaPrinter;

class SchemaTest extends TestCase {
    use MatchesSnapshots;

    public function setUp(): void {
        MagentoManager::reset();
    }

    public function tearDown(): void {
        MagentoManager::logQueries();
    }

    public function onNotSuccessfulTest($e): void {
        MagentoManager::logQueries();

        throw $e;
    }

    public function testSdl() {
        MagentoManager::init();

        $app = Mage::app();
        $store = $app->getStore();
        $helper = Mage::helper("mageql/data");
        $layout = Mage::getSingleton("core/layout");

        $layout->setArea(MageQL_Core_Router_GraphQL::GRAPHQL_AREA);
        $app->loadArea($layout->getArea());

        $session = Mage::getSingleton("core/session", ["name" => "frontend"])
            ->start();

        $context = Mage::getModel("mageql/context", [
            "store" => $store,
            "session" => $session,
            "schemaName" => "default",
        ]);

        Mage::register(MageQL_Core_Model_Context::REGISTRY_KEY, $context);

        $schema = $helper->loadSchema($context, [
            "unreachable" => true,
        ]);

        $sdl = SchemaPrinter::doPrint($schema, [
            "schemaDescriptions" => true,
        ]);

        $this->assertMatchesTextSnapshot($sdl);
    }
}
