<?php

declare(strict_types=1);

use Spatie\Snapshots\MatchesSnapshots;

use PHPUnit\Framework\TestCase;
use Crossroads\Magento\Test\Integration\MagentoManager;
use Crossroads\Magento\Test\Integration\Request;

class FilterTest extends TestCase {
    use MatchesSnapshots;

    public function setUp(): void {
        MagentoManager::reset();
    }

    public function tearDown(): void {
        MagentoManager::logQueries();
    }

    public function onNotSuccessfulTest($e): void {
        MagentoManager::logQueries();

        throw $e;
    }

    /*
    public function testProductPriceFilter() {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
            products (
                priceFilter: { minValue:0, maxValue:10 }
            ) {
                items {
                    sku
                    price { incVat }
                }
            }
        }'));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }


    public function testProductsPriceFilter2() {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
                products (
                    priceFilter: { minValue:10, maxValue:15 }
                ) {
                    items {
                        sku
                        price { incVat }
                    }
                }
            }'
        ));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }

    public function testProductPriceFilter3() {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
                products (
                    priceFilter: { minValue:0, maxValue:5 }
                ) {
                    items {
                        sku
                        price { incVat }
                    }
                }
            }'
        ));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }

    public function testProductAttributeFilter() {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
                products (
                    attributeFilter: [ { code:"manufacturer", value:"Manufacturer A" } ]
                ) {
                    totalCount
                    items {
                        sku
                    }
                }
            }'
        ));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }


    public function testProductAttributeFilter2() {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
                products (
                    attributeFilter: [ { code:"manufacturer", value:"Manufacturer B" } ]
                ) {
                    totalCount
                    items {
                        sku
                    }
                }
            }'
        ));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }

    public function testProductAttributeFilter3() {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
                products (
                    attributeFilter: [ { code:"manufacturer", value:"Manufacturer X" } ]
                ) {
                    totalCount
                    items {
                        sku
                    }
                }
            }'
        ));


        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }

    public function testProductAttributeAndPriceFilter() {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
            products (
                attributeFilter: [ { code:"manufacturer", value:"Manufacturer B" } ]
                priceFilter: { minValue:10 }
            ) {
                totalCount
                items {
                    sku
                    price { incVat }
                }
            }
        }'));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }

    public function testProductAttributeAndPriceFilterMax() {
        $res = MagentoManager::runRequest(new Request("POST /graphql", ["Content-Type" => "application/graphql"], 'query {
            products (
                attributeFilter: [ { code:"manufacturer", value:"Manufacturer B" } ]
                priceFilter: { maxValue:10 }
            ) {
                totalCount
                items {
                    sku
                    price { incVat }
                }
            }
        }'));

        $this->assertMatchesJsonSnapshot($res->getBody());
        $this->assertEquals(200, $res->getHttpResponseCode());
        $this->assertEquals("application/json; charset=utf-8", $res->getHeader("Content-Type"));
    }
     */
}