# Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

## [4.0.0] - 2020-05-19
### Added
- `products` query which lists all available products.
### Changed
- `ConfigurationOptionItem` interal type is now an object of
  `MageQL_Catalog_Model_Product_Configurable_Option`.
- Dropped support for PHP 7.2 and 7.3
### Deprecated
- `productsBy`, use `products` with a `filter` parameter instead.

## [3.1.1] - 2020-04-14
### Fixed
- `PaginatedProducts`.`totalCount` is now zero when `productsBySearch` do not
  match anything.

## [3.1.0] - 2020-04-08
### Added
- New `recentlyViewedProducts` query.
- New `attributeFilter` and `priceFilter` arguments to `Categories`.`products`,
  `bestsellingProducts` and `productsBySearch` which allows consumers to filter
  the product collection based on attributes and price.
### Fixed
- Missing implementations for `ProductOption` interface.

## [3.0.0] - 2020-02-10
### Changed
- All image attributes now use the `ImageData` type.

## [2.0.1] - 2020-01-14
### Added
- `MageQL_Catalog_Model_Product::$LIST_ATTRIBUTE_FIELDS` which is a list of
  fields containing key-maps of attributes based on their attribute names and
  can be modified by other modules.
- `manufacturer` is now applied to bundles, configurable, and simple products
  in tests.

## [2.0.0] - 2019-12-16
### Added
- New `ProductOption` interface describing options and selections for
  configurable- and bundle-products.
- `ConfigurationOptionItem`.`price` containing the price for the configuration
  option.
### Changed
- `ConfigurationOptionItem`.`product` is now a `ProductOption`.
- `BundleSelection`.`product` is now a `ProductOption`.
### Removed
- `ConfigurationOptionItem`.`product` no longer contains `price` or `buyRequest`.
- `BundleSelection`.`product` no longer contains `price` or `buyRequest`.
### Fixed
- Product searches now record the number of hits.

## [1.2.0] - 2019-12-13
### Added
- Added a `categories` field to `ListProduct` and `ProductDetail` listing the
  categories in which the product is included.
### Fixed
- Route will now return null when the product and/or category fails to load
  instead of crashing.
- Category images will now display placeholders if the file cannot be found.

## [1.1.3] - 2019-11-25
### Changed
- Allow more qty variation in tests.
### Fixed
- Fixed minor type-documentation.

## [1.1.2] - 2019-11-22
### Fixed
- Bundle option in-stock and selection percent price in tests.

## [1.1.1] - 2019-11-21
### Fixed
- Bundle selection pricing is now displayed correctly.

## [1.1.0] - 2019-11-21
### Added
- Bundles are now supported.

## [1.0.4] - 2019-10-31
### Fixed
- Products are no longer reachable through their sku or route if they
  are not visible or assigned to the specific website.

## [1.0.3] - 2019-08-21
### Changed
- Refactor with types

## [1.0.2] - 2019-08-21
### Added
- Added `Category`.`parent` to allow fetching of parent category for eg.
  breadcrumbs and category-pages.
### Changed
- Use `Deferred` to improve performance on `Category`.`children` and `categoryNav`.

## [1.0.1] - 2019-08-16
### Changed
- Updated package dependencies to reference actual versions.

## [1.0.0] - 2019-08-16
### Added
- Initial version